/*
 * Decompiled with CFR 0.152.
 */
package pmg_tools;

import java.io.BufferedWriter;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlUtils {
    String script = "";
    String text = "";
    NamedNodeMap map = null;
    Hashtable<String, String> ids = new Hashtable();
    int counter = 1;

    public static Element getElement(Document doc, String tagName, int index) {
        NodeList rows = doc.getDocumentElement().getElementsByTagName(tagName);
        Node obj = null;
        try {
            obj = rows.item(index);
        }
        catch (Exception ie) {
            obj = null;
        }
        return (Element)obj;
    }

    public static final String getWord(Node node) {
        if (node != null && node.hasChildNodes()) {
            for (Node kid = node.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 3) continue;
                return kid.getNodeValue();
            }
        }
        return "";
    }

    public static int getSize(Document doc, String tagName) {
        NodeList rows = doc.getDocumentElement().getElementsByTagName(tagName);
        return rows.getLength();
    }

    public static Element getChildElement(Element nod, String tagName, int index) {
        NodeList rows = nod.getElementsByTagName(tagName);
        return (Element)rows.item(index);
    }

    public static Node getChildNode(Element nod, String tagName, int index) {
        NodeList rows = nod.getElementsByTagName(tagName);
        return rows.item(index);
    }

    public static int getChildSize(Element nod, String tagName) {
        NodeList rows = nod.getElementsByTagName(tagName);
        return rows.getLength();
    }

    public static String getValue(Element e, String tagName) {
        try {
            NamedNodeMap att = e.getAttributes();
            Node a = att.getNamedItem(tagName);
            String s = a.getNodeValue();
            return s;
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static String getNodeValue(Node e, String tagName) {
        try {
            NamedNodeMap att = e.getAttributes();
            Node a = att.getNamedItem(tagName);
            String s = a.getNodeValue();
            return s;
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
            return null;
        }
    }

    public Node findNode(Node node, String name) {
        if (node.getNodeName().equals(name)) {
            return node;
        }
        if (node.hasChildNodes()) {
            NodeList list = node.getChildNodes();
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                Node found = this.findNode(list.item(i), name);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public void removeTerminals(Node node) {
        Node father = node.getParentNode();
        NodeList nl = father.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("word")) continue;
            father.removeChild(nl.item(i));
            --i;
        }
    }

    public Node removeNonTerminals(Node node) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("node")) continue;
            node.removeChild(nl.item(i));
            --i;
        }
        return node;
    }

    public boolean isRecursive(Node node) {
        boolean recursive = false;
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("node")) continue;
            recursive = true;
            break;
        }
        return recursive;
    }

    public Node getTTree(Node node) {
        Node parent = node.getParentNode();
        String[] att = new String[]{"id"};
        if (parent != null) {
            this.removeAttributes((Element)parent, att, true);
            try {
                parent.removeChild(node);
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
        return parent;
    }

    public static Node findNextNode(Node node, String name) {
        for (Node n = node = node.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (!(n.getNodeType() == 1 & n.getNodeName().equals(name))) continue;
            return n;
        }
        return null;
    }

    public static Node findNextNode(Node node, String name, int i) {
        int j = 1;
        for (Node n = node = node.getNextSibling(); n != null; n = n.getNextSibling()) {
            if (!(n.getNodeType() == 1 & n.getNodeName().equals(name)) || j != i) continue;
            return n;
        }
        ++j;
        return null;
    }

    public ArrayList reverse(ArrayList p) {
        ArrayList reversed = new ArrayList();
        for (int i = p.size() - 1; i >= 0; --i) {
            Object obj = p.get(i);
            reversed.add(obj);
        }
        return reversed;
    }

    public static int countSentences(Node node, String name) {
        int i = 0;
        while (node != null) {
            node = XmlUtils.findNextNode(node, name);
            ++i;
        }
        return i;
    }

    public static String[] getAttributes(Node node) {
        String[] att = new String[3];
        int width = 0;
        NamedNodeMap attributes = node.getAttributes();
        int length = attributes.getLength();
        int height = length + 1;
        att[2] = "";
        for (int j = 0; j < length; ++j) {
            Node attribute = attributes.item(j);
            String name = attribute.getNodeName();
            String value = attribute.getNodeValue();
            if (!(name.equals("cat") || name.equals("x") || name.equals("y"))) {
                att[2] = att[2] + name + "= " + value + "<br>";
                if (width >= name.length() + value.length()) continue;
                width = name.length() + value.length();
                continue;
            }
            --height;
        }
        if (att[2].equals("")) {
            width = 16;
            att[2] = "no additional info";
        }
        att[0] = Integer.toString(width);
        att[1] = Integer.toString(height);
        return att;
    }

    public void showNode(Node node, boolean has_children) {
        System.out.print("\nNODO: " + node.getNodeName() + " cat:" + ((Element)node).getAttribute("cat"));
        if (((Element)node).hasAttribute("id")) {
            System.out.print(" id: " + ((Element)node).getAttribute("id") + "\n");
        }
        if (((Element)node).hasAttribute("role")) {
            System.out.print(" role: " + ((Element)node).getAttribute("role") + "\n");
        } else {
            System.out.print("\n");
        }
        if (node.hasChildNodes() && has_children) {
            for (Node kid = node.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 1) continue;
                System.out.print("CHILD NODE: " + kid.getNodeName() + " cat:" + ((Element)kid).getAttribute("cat"));
                if (((Element)kid).hasAttribute("role")) {
                    System.out.print(" role: " + ((Element)kid).getAttribute("role") + "\n");
                    continue;
                }
                System.out.print("\n");
            }
        }
    }

    public String getPhaseString(Node node) {
        String s = ((Element)node).getAttribute("cat");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            s = s + "\t" + ((Element)children.item(i)).getAttribute("cat");
        }
        return s;
    }

    public void resetCounter() {
        this.counter = 1;
    }

    public void elementExplorer(Element el) {
        if (el != null && el.hasChildNodes()) {
            for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 1) continue;
                if (kid.getNodeName().equals("node") && !((Element)kid).hasAttribute("role")) {
                    System.out.println(this.counter + " " + this.getStringXML(kid, true) + "\n");
                    ++this.counter;
                } else if (kid.getNodeName().equals("node") && ((Element)kid).getAttribute("role").equals("")) {
                    System.out.println(this.counter + " " + this.getStringXML(kid, true) + "\n");
                    ++this.counter;
                }
                this.elementExplorer((Element)kid);
            }
        }
    }

    public void checkSequenceCostituecy(Element el, String seq) {
        if (el != null && el.hasChildNodes()) {
            String cat_seq = "";
            for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() == 1) {
                    cat_seq = cat_seq + ((Element)kid).getAttribute("cat") + " ";
                    this.checkSequenceCostituecy((Element)kid, seq);
                }
                if (!cat_seq.matches(seq)) continue;
                System.out.println(this.counter + " " + this.getStringXML(el, true) + "\n");
                ++this.counter;
            }
        }
    }

    public void checkParentCostituecy(Element el, String seq) {
        if (el != null) {
            String father = el.getAttribute("cat");
            NodeList children = el.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1 || children.item(i).getNodeType() == 3) continue;
                String cat = ((Element)children.item(i)).getAttribute("cat");
                String cat_seq = father + "<" + cat;
                if (cat_seq.contains(seq)) {
                    System.out.println(this.counter + " " + this.getStringXML(el, true) + "\n");
                    ++this.counter;
                }
                this.checkParentCostituecy((Element)children.item(i), seq);
            }
        }
    }

    public String getParseXML(Document d) {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "ISO-8859-1");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        DOMSource source = new DOMSource(d);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return sw.toString();
    }

    public String getStringXML(Node node, boolean format) {
        String processedXML = null;
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            if (format) {
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
            }
            transformer.setOutputProperty("encoding", "ISO-8859-1");
            DOMSource dSource = new DOMSource(node);
            StringWriter sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(dSource, sr);
            StringWriter anotherSW = (StringWriter)sr.getWriter();
            StringBuffer sBuffer = anotherSW.getBuffer();
            processedXML = sBuffer.toString();
        }
        catch (Exception ex) {
            System.out.println("Exception: " + ex.getMessage());
            ex.printStackTrace();
        }
        return processedXML.replace("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>", "");
    }

    public void arrayReverse(String[] s) {
        int lenght = s.length;
        int half_length = lenght / 2;
        for (int i = 0; i < half_length; ++i) {
            String t = s[i];
            s[i] = s[lenght - (1 + i)];
            s[lenght - (1 + i)] = t;
        }
    }

    private static String formatXML(String s) {
        s = s.replace("   ", "\t");
        s = s.replace("<text", "<!DOCTYPE text SYSTEM \"SUT.dtd\">\n\n<text");
        s = s.replace("<expression", "\n<expression");
        s = s.replace("</expression>", "</expression>\n");
        s = s.replace("</text>", "\n</text>");
        return s;
    }

    public static void writeXML(File file, String xmltext) {
        String clean_xml = XmlUtils.formatXML(xmltext);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            out.write(clean_xml);
            out.close();
            System.out.println("Writing process completed.");
        }
        catch (UnsupportedEncodingException ue) {
            System.out.println("Not supported : " + ue);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public static void writeFile(String file_name, String text) {
        File file = new File(file_name);
        try {
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
            out.write(text);
            out.close();
            System.out.println("Writing process completed.");
        }
        catch (UnsupportedEncodingException ue) {
            System.out.println("Not supported : " + ue);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public void clearText() {
        this.text = "";
    }

    public void setText(Element el) {
        if (el != null && el.hasChildNodes()) {
            for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() == 3) {
                    this.text = this.text + kid.getTextContent() + " ";
                    continue;
                }
                if (kid.getNodeType() != 1) continue;
                this.setText((Element)kid);
            }
        }
    }

    public String renumberSTTrees(String s) {
        this.ids.clear();
        String[] ssplit = s.split("\t");
        String[] ss_liv = ssplit[0].split("id=\"");
        int size = ss_liv.length;
        for (int i = 1; i < size; ++i) {
            String id_old = ss_liv[i].substring(0, ss_liv[i].indexOf("\""));
            String id_new = Integer.valueOf(i - 1).toString();
            s = s.replace("\"" + id_old + "\"", "\"" + id_new + "\"");
            this.ids.put(id_new, id_old);
        }
        return s;
    }

    public void removePunctuation(Element el) {
        if (el.getNodeName().equals("word")) {
            if (el.getAttribute("cat").substring(0, 1).equals("E")) {
                el.getParentNode().removeChild(el);
            }
        } else if (el.hasChildNodes()) {
            for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 1) continue;
                this.removePunctuation((Element)kid);
            }
        }
    }

    public void removeAttributes(Element el, String[] att, boolean recursive) {
        if (el != null) {
            int size = att.length;
            for (int i = 0; i < size; ++i) {
                if (!el.hasAttribute(att[i])) continue;
                el.removeAttribute(att[i]);
            }
            if (el.hasChildNodes() && recursive) {
                for (Node kid = el.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                    if (kid.getNodeType() != 1) continue;
                    this.removeAttributes((Element)kid, att, true);
                }
            }
        }
    }

    public void removeMarks(Element el) {
        NodeList nodelist = el.getChildNodes();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            if (nodelist.item(i).getNodeType() != 1) continue;
            if (nodelist.item(i).getNodeName().equals("word") && ((Element)nodelist.item(i)).getAttribute("cat").substring(0, 1).equals("E")) {
                el.removeChild(nodelist.item(i));
                --i;
                continue;
            }
            this.removeMarks((Element)nodelist.item(i));
        }
    }

    public void extrapose(Element father, Element node, String[] roles) {
        NodeList nodelist = node.getChildNodes();
        int size = roles.length;
        block0: for (int i = 0; i < nodelist.getLength(); ++i) {
            if (nodelist.item(i).getNodeType() != 1) continue;
            for (int ic = 0; ic < size; ++ic) {
                if (!((Element)nodelist.item(i)).getAttribute("role").equals(roles[ic])) continue;
                Node removed = node.removeChild(nodelist.item(i));
                father.insertBefore(removed, node.getNextSibling());
                continue block0;
            }
        }
    }

    public int getWordsNumber(Node node) {
        this.counter = 0;
        this.countWords(node);
        return this.counter;
    }

    public void countWords(Node node) {
        NodeList nodelist = node.getChildNodes();
        int size = nodelist.getLength();
        for (int i = 0; i < size; ++i) {
            if (nodelist.item(i).getNodeType() != 1) continue;
            if (nodelist.item(i).getNodeName().equals("word")) {
                if (nodelist.item(i).getTextContent().equals("")) continue;
                String[] s = nodelist.item(i).getTextContent().split(" ");
                if (s.length > 0) {
                    this.counter += s.length;
                    continue;
                }
                ++this.counter;
                continue;
            }
            this.countWords(nodelist.item(i));
        }
    }

    public boolean isLastLeaf(Node n) {
        boolean lastleaf = true;
        NodeList nl = n.getParentNode().getChildNodes();
        int size = nl.getLength();
        if (size > 1) {
            lastleaf = false;
        }
        return lastleaf;
    }

    public static String removeMarks(String s) {
        s = s.replaceAll("[!?,;:.\\(\\)\"]", "");
        return s;
    }

    public boolean isPunctuation(String s) {
        boolean punct = false;
        if (s.matches("[!?,;:.\\(\\)\"]")) {
            punct = true;
        }
        return punct;
    }

    public Document cloneDocument(Document doc) {
        Element root = doc.getDocumentElement();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        DOMImplementation impl = builder.getDOMImplementation();
        Document cloned_doc = impl.createDocument(null, root.getNodeName(), null);
        Element root_tt = cloned_doc.getDocumentElement();
        NamedNodeMap attributes = root.getAttributes();
        int size = attributes.getLength();
        for (int i = 0; i < size; ++i) {
            root_tt.setAttribute(attributes.item(i).getNodeName(), attributes.item(i).getNodeValue());
        }
        NodeList children = root.getChildNodes();
        int sizec = children.getLength();
        for (int i = 0; i < sizec; ++i) {
            Node node = cloned_doc.importNode(children.item(i), true);
            root_tt.appendChild(node);
        }
        return cloned_doc;
    }

    public Element parseXML(String in) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        CharArrayReader reader = new CharArrayReader(in.toCharArray());
        Document doc = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            doc = builder.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(XmlUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return doc.getDocumentElement();
    }
}

