/*
 * Decompiled with CFR 0.152.
 */
package pmg_tools;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLReader {
    public Document doc;
    public Node root;

    public XMLReader(String xmlFileName) {
        this.doc = this.parseFile(xmlFileName);
        this.root = this.doc.getDocumentElement();
    }

    public Node getRoot() {
        return this.root;
    }

    public Document getDoc() {
        return this.doc;
    }

    public Document parseFile(String fileName) {
        DocumentBuilder docBuilder;
        System.out.println("Parsing XML file... " + fileName);
        this.doc = null;
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(true);
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            docBuilder = docBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            System.out.println("Wrong parser configuration: " + e.getMessage());
            return null;
        }
        File sourceFile = new File(fileName);
        try {
            this.doc = docBuilder.parse(sourceFile);
        }
        catch (SAXException e) {
            System.out.println("Wrong XML file structure: " + e.getMessage());
            return null;
        }
        catch (IOException e) {
            System.out.println("Could not read source file: " + e.getMessage());
        }
        System.out.println("XML file parsed");
        return this.doc;
    }
}

