/*
 * Decompiled with CFR 0.152.
 */
package pmg_tools;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pmg_tools.PMG_GrammarLoader;
import pmg_tools.XmlUtils;

public class PMG_Parser {
    public Document parse = null;
    PMG_GrammarLoader grammar = null;
    XmlUtils xutils = new XmlUtils();
    Element active_node = null;
    Element right_most_head = null;
    Element moved_node = null;
    Element predicted_node = null;
    Element last_resource_pending = null;
    Element first_chart_node = null;
    List tt_found = new ArrayList();
    List pos_found = new ArrayList();
    List ps_found = new ArrayList();
    List lp_found = new ArrayList();
    List pending = new ArrayList();
    String[] p_default = new String[]{"<node cat=\"VP\">", "<node cat=\"NP\">"};
    String[] intransitive = new String[]{"<node cat=\"NP\" role=\"arg.subj\">"};
    String[] transitive = new String[]{"<node cat=\"NP\" role=\"arg.subj\">", "<node cat=\"NP\" role=\"arg.obj\">"};
    List[] chart = null;
    List[] ma_buffers = null;
    List[] r_buffers = null;
    int chart_position = 0;
    int size_chart = 0;
    int size_sentence = 0;
    int size_tt_sel = 0;
    int size_ps_found = 0;
    int size_lp_found = 0;
    int size_phases = 0;
    int count_XP = 0;
    int counter = 0;
    boolean complete = false;
    boolean tracing = true;

    public PMG_Parser(PMG_GrammarLoader gr, String sentence, boolean trace) {
        this.tracing = trace;
        this.grammar = gr;
        String[] tokens = PMG_Parser.getTokens(sentence);
        this.size_chart = tokens.length + 1;
        this.size_sentence = this.size_chart - 1;
        this.chart = new List[this.size_chart];
        this.ma_buffers = new List[this.size_chart];
        this.r_buffers = new List[this.size_chart];
        for (int i = 0; i < this.size_chart; ++i) {
            this.chart[i] = new ArrayList();
            this.ma_buffers[i] = new ArrayList();
            this.r_buffers[i] = new ArrayList();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(PMG_Parser.class.getName()).log(Level.SEVERE, null, ex);
        }
        DOMImplementation impl = builder.getDOMImplementation();
        this.parse = impl.createDocument(null, "node", null);
        Element root = this.parse.getDocumentElement();
        Element dummy_NP = this.parse.createElement("node");
        dummy_NP.setAttribute("cat", "NP");
        Element dummy_VP = this.parse.createElement("node");
        dummy_VP.setAttribute("cat", "VP");
        this.first_chart_node = dummy_NP;
        try {
            this.getPotentialCorpusTTrees(sentence);
            this.getPotentialCorpusPoS(sentence);
            this.getPotentialPoS(sentence);
            this.getPhases();
            this.getPotentialPhaseships();
            this.getPotentialLeftEdges();
        }
        catch (IOException ex) {
            Logger.getLogger(PMG_Parser.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.removePoSDuplicated();
        this.size_ps_found = this.ps_found.size();
        this.size_lp_found = this.lp_found.size();
        this.chart[0].add(dummy_NP);
        this.ma_buffers[this.chart_position].add(new ArrayList());
        this.chart[0].add(dummy_VP);
        this.ma_buffers[this.chart_position].add(new ArrayList());
        for (int i = 0; i < this.size_chart - 1; ++i) {
            if (this.tracing) {
                System.out.println("\n\n========= PASS " + i + " =========");
            }
            this.predict(this.chart[i]);
            this.scan(tokens, i);
            this.complete();
            ++this.chart_position;
        }
        if (this.tracing) {
            System.out.println("\n\n****** END " + this.counter + " merges! ******");
        }
        if (!this.chart[this.size_sentence].isEmpty()) {
            this.close();
            if (!this.chart[this.size_sentence].isEmpty()) {
                Element el = (Element)this.chart[this.size_sentence].get(0);
                NamedNodeMap at = el.getAttributes();
                for (int i = 0; i < at.getLength(); ++i) {
                    root.setAttributeNode((Attr)((Attr)at.item(i)).cloneNode(true));
                }
                NodeList nl = el.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    root.appendChild(nl.item(0));
                    --i;
                }
            }
        }
    }

    public PMG_Parser(PMG_GrammarLoader gr, String text) {
        this.grammar = gr;
        this.tt_found = new ArrayList();
        this.pos_found = new ArrayList();
        this.ps_found = new ArrayList();
        this.lp_found = new ArrayList();
        this.size_tt_sel = 0;
        this.size_phases = 0;
        this.count_XP = 0;
        try {
            this.getPotentialCorpusTTrees(text);
            this.getPotentialCorpusPoS(text);
            this.getPotentialPoS(text);
            this.getPhases();
            this.getPotentialPhaseships();
            this.getPotentialLeftEdges();
        }
        catch (IOException ex) {
            Logger.getLogger(PMG_Parser.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.removePoSDuplicated();
        this.size_ps_found = this.ps_found.size();
        this.size_lp_found = this.lp_found.size();
    }

    public void parse(String sentence, boolean trace) {
        this.parse = null;
        this.active_node = null;
        this.right_most_head = null;
        this.moved_node = null;
        this.predicted_node = null;
        this.last_resource_pending = null;
        this.first_chart_node = null;
        this.pending = new ArrayList();
        this.chart = null;
        this.ma_buffers = null;
        this.r_buffers = null;
        this.chart_position = 0;
        this.size_chart = 0;
        this.size_sentence = 0;
        this.counter = 0;
        this.complete = false;
        this.tracing = trace;
        String[] tokens = PMG_Parser.getTokens(sentence);
        this.size_chart = tokens.length + 1;
        this.size_sentence = this.size_chart - 1;
        this.chart = new List[this.size_chart];
        this.ma_buffers = new List[this.size_chart];
        this.r_buffers = new List[this.size_chart];
        for (int i = 0; i < this.size_chart; ++i) {
            this.chart[i] = new ArrayList();
            this.ma_buffers[i] = new ArrayList();
            this.r_buffers[i] = new ArrayList();
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(PMG_Parser.class.getName()).log(Level.SEVERE, null, ex);
        }
        DOMImplementation impl = builder.getDOMImplementation();
        this.parse = impl.createDocument(null, "node", null);
        Element root = this.parse.getDocumentElement();
        Element dummy_NP = this.parse.createElement("node");
        dummy_NP.setAttribute("cat", "NP");
        Element dummy_VP = this.parse.createElement("node");
        dummy_VP.setAttribute("cat", "VP");
        this.first_chart_node = dummy_NP;
        this.chart[0].add(dummy_NP);
        this.ma_buffers[this.chart_position].add(new ArrayList());
        this.chart[0].add(dummy_VP);
        this.ma_buffers[this.chart_position].add(new ArrayList());
        for (int i = 0; i < this.size_chart - 1; ++i) {
            if (this.tracing) {
                System.out.println("\n\n========= PASS " + i + " =========");
            }
            this.predict(this.chart[i]);
            this.scan(tokens, i);
            this.complete();
            ++this.chart_position;
        }
        if (this.tracing) {
            System.out.println("\n\n****** END " + this.counter + " merges! ******");
        }
        if (!this.chart[this.size_sentence].isEmpty()) {
            this.close();
            if (!this.chart[this.size_sentence].isEmpty()) {
                Element el = (Element)this.chart[this.size_sentence].get(0);
                NamedNodeMap at = el.getAttributes();
                for (int i = 0; i < at.getLength(); ++i) {
                    root.setAttributeNode((Attr)((Attr)at.item(i)).cloneNode(true));
                }
                NodeList nl = el.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    root.appendChild(nl.item(0));
                    --i;
                }
            }
        }
    }

    private String[] guessPoS(String word) {
        String[] guessedPos = new String[2];
        if (word.matches("\\d*")) {
            guessedPos[0] = "A.num.card";
            guessedPos[1] = "m.p";
        } else if (word.matches("(\\d|[^\\w])*")) {
            guessedPos[0] = "A.num.card";
            guessedPos[1] = "m.s";
        } else {
            guessedPos[0] = "N.comm.count.inanim";
            guessedPos[1] = "m.s";
        }
        return guessedPos;
    }

    private void predict(List chart_nodes) {
        if (this.tracing) {
            System.out.println("PREDICT at chart position:" + this.chart_position);
        }
        int size = chart_nodes.size();
        String subcat = "";
        for (int n = 0; n < size; ++n) {
            Element new_node_NP_S_bis;
            Node new_node_bis;
            Element new_node_NP_O;
            Element new_node_NP_S;
            Node new_node;
            Element new_node_NP;
            Node new_node_1;
            Node node = (Node)chart_nodes.get(n);
            if (this.tracing) {
                System.out.println("original node:" + this.xutils.getStringXML(node, true));
            }
            this.active_node = null;
            this.setActiveNode((Element)node);
            Node head = this.getHead(this.active_node);
            if (this.tracing) {
                System.out.println("active node:" + this.xutils.getStringXML(this.active_node, true));
            }
            if (this.tracing) {
                System.out.println("head:" + this.xutils.getStringXML(head, true));
            }
            if (head == null) continue;
            subcat = ((Element)head).hasAttribute("subcat") ? ((Element)head).getAttribute("subcat") : "";
            if (this.tracing) {
                System.out.println("subcat: " + subcat);
            }
            if (subcat.equals("default")) {
                node.removeChild(node.getFirstChild());
                this.chart[this.chart_position].remove(0);
                new_node_1 = node.cloneNode(true);
                new_node_NP = this.parse.createElement("node");
                new_node_NP.setAttribute("cat", "NP");
                new_node_1.appendChild(new_node_NP);
                this.chart[this.chart_position].add(new_node_1);
                this.ma_buffers[this.chart_position].add(new ArrayList());
                Node new_node_2 = node.cloneNode(true);
                Element new_node_VP = this.parse.createElement("node");
                new_node_VP.setAttribute("cat", "VP");
                new_node_2.appendChild(new_node_VP);
                this.chart[this.chart_position].add(new_node_2);
                this.ma_buffers[this.chart_position].add(new ArrayList());
                continue;
            }
            if (subcat.equals("intransitive")) {
                if (this.hasChildRole(this.active_node, "arg.subj")) continue;
                new_node_1 = node.cloneNode(true);
                new_node_NP = this.parse.createElement("node");
                new_node_NP.setAttribute("cat", "NP");
                new_node_NP.setAttribute("role", "arg.subj");
                new_node_1.appendChild(new_node_NP);
                this.chart[this.chart_position].add(new_node_1);
                this.ma_buffers[this.chart_position].add(new ArrayList());
                continue;
            }
            if (subcat.equals("transitive")) {
                new_node = node.cloneNode(true);
                if (!this.hasChildRole(this.active_node, "arg.subj")) {
                    new_node_NP_S = this.parse.createElement("node");
                    new_node_NP_S.setAttribute("cat", "NP");
                    new_node_NP_S.setAttribute("role", "arg.subj");
                    new_node.appendChild(new_node_NP_S);
                }
                if (!this.hasChildRole(this.active_node, "arg.obj")) {
                    new_node_NP_O = this.parse.createElement("node");
                    new_node_NP_O.setAttribute("cat", "NP");
                    new_node_NP_O.setAttribute("role", "arg.obj");
                    new_node.appendChild(new_node_NP_O);
                }
                this.chart[this.chart_position].add(new_node);
                this.ma_buffers[this.chart_position].add(new ArrayList());
                continue;
            }
            if (subcat.equals("copula")) {
                new_node = node.cloneNode(true);
                if (!this.hasChildRole(this.active_node, "arg.subj")) {
                    new_node_NP_S = this.parse.createElement("node");
                    new_node_NP_S.setAttribute("cat", "NP");
                    new_node_NP_S.setAttribute("role", "arg.subj");
                    new_node.appendChild(new_node_NP_S);
                }
                new_node_NP_O = this.parse.createElement("node");
                new_node_NP_O.setAttribute("cat", "AP");
                new_node_NP_O.setAttribute("role", "arg.predobj");
                new_node.appendChild(new_node_NP_O);
                this.chart[this.chart_position].add(new_node);
                this.ma_buffers[this.chart_position].add(new ArrayList());
                new_node_bis = node.cloneNode(true);
                if (!this.hasChildRole(this.active_node, "arg.subj")) {
                    new_node_NP_S_bis = this.parse.createElement("node");
                    new_node_NP_S_bis.setAttribute("cat", "NP");
                    new_node_NP_S_bis.setAttribute("role", "arg.subj");
                    new_node.appendChild(new_node_NP_S_bis);
                }
                Element new_node_NP_O_bis = this.parse.createElement("node");
                new_node_NP_O_bis.setAttribute("cat", "NP");
                new_node_NP_O_bis.setAttribute("role", "arg.predobj");
                new_node_bis.appendChild(new_node_NP_O_bis);
                this.chart[this.chart_position].add(new_node_bis);
                this.ma_buffers[this.chart_position].add(new ArrayList());
                continue;
            }
            if (subcat.equals("ditransitive")) {
                new_node = node.cloneNode(true);
                if (!this.hasChildRole(this.active_node, "arg.subj")) {
                    new_node_NP_S = this.parse.createElement("node");
                    new_node_NP_S.setAttribute("cat", "NP");
                    new_node_NP_S.setAttribute("role", "arg.subj");
                    new_node.appendChild(new_node_NP_S);
                }
                new_node_NP_O = this.parse.createElement("node");
                new_node_NP_O.setAttribute("cat", "NP");
                new_node_NP_O.setAttribute("role", "arg.obj");
                new_node.appendChild(new_node_NP_O);
                Element new_node_NP_I = this.parse.createElement("node");
                new_node_NP_I.setAttribute("cat", "NP");
                new_node_NP_I.setAttribute("role", "arg.indobj");
                new_node.appendChild(new_node_NP_I);
                this.chart[this.chart_position].add(new_node);
                this.ma_buffers[this.chart_position].add(new ArrayList());
                continue;
            }
            if (!subcat.equals("passive")) continue;
            new_node = node.cloneNode(true);
            if (!this.hasChildRole(this.active_node, "arg.subj")) {
                new_node_NP_S = this.parse.createElement("node");
                new_node_NP_S.setAttribute("cat", "NP");
                new_node_NP_S.setAttribute("role", "arg.subj");
                new_node.appendChild(new_node_NP_S);
            }
            Element new_node_NP_I = this.parse.createElement("node");
            new_node_NP_I.setAttribute("cat", "NP");
            new_node_NP_I.setAttribute("role", "arg.indobj");
            new_node.appendChild(new_node_NP_I);
            this.chart[this.chart_position].add(new_node);
            this.ma_buffers[this.chart_position].add(new ArrayList());
            new_node_bis = node.cloneNode(true);
            if (!this.hasChildRole(this.active_node, "arg.subj")) {
                new_node_NP_S_bis = this.parse.createElement("node");
                new_node_NP_S_bis.setAttribute("cat", "NP");
                new_node_NP_S_bis.setAttribute("role", "arg.subj");
                new_node.appendChild(new_node_NP_S_bis);
            }
            this.chart[this.chart_position].add(new_node_bis);
            this.ma_buffers[this.chart_position].add(new ArrayList());
        }
    }

    private void scan(String[] tokens, int i) {
        if (this.tracing) {
            System.out.println("SCANNING '" + tokens[i] + "'...");
        }
        this.pending.clear();
        this.pending.addAll(this.getTTrees(tokens, i));
        this.pending.addAll(this.getPoS(tokens[i], i));
    }

    private void complete() {
        if (this.tracing) {
            System.out.println("COMPLETING...");
        }
        Object n = null;
        int size_pending = this.pending.size();
        int size_selectedchart = this.chart[this.chart_position].size();
        if (size_pending > 100) {
            if (this.tracing) {
                System.out.println("!!! size_pending=" + size_pending);
            }
            size_pending = 100;
        }
        if (size_selectedchart > 10) {
            if (this.tracing) {
                System.out.println("!!! size_chart=" + size_selectedchart);
            }
            size_selectedchart = 10;
        }
        boolean at_least_one_merge = false;
        for (int i = 0; i < size_pending; ++i) {
            Element pending_node = (Element)this.pending.remove(0);
            if (i == 0) {
                this.last_resource_pending = pending_node;
            }
            for (int j = 0; j < size_selectedchart; ++j) {
                Node merged_node;
                Element chart_node = (Element)this.chart[this.chart_position].get(j);
                List ma_buffer = (List)this.ma_buffers[this.chart_position].get(j);
                if (i == 0) {
                    this.first_chart_node = chart_node;
                }
                if (this.tracing) {
                    System.out.println("\nCOMPLETE at chart#" + this.chart_position + " (pending: " + i + " chart:" + j + ")");
                }
                if (this.tracing) {
                    System.out.println("chart_node:\n" + this.xutils.getStringXML(chart_node, true) + "\npending_node:\n" + this.xutils.getStringXML(pending_node, true) + " ma_buffer size: " + ma_buffer.size());
                }
                if (!ma_buffer.isEmpty()) {
                    int size = ma_buffer.size();
                    if (this.tracing) {
                        System.out.println("Size of ma_buffer: " + size);
                    }
                    for (int w = 0; w < size; ++w) {
                        Element move_node = (Element)ma_buffer.get(w);
                        if (move_node == null) continue;
                        if (this.tracing) {
                            System.out.println("ATTEMPT TO RE-MERGE: move_node:\n" + this.xutils.getStringXML(move_node, true) + " \nwith chart_node:\n" + this.xutils.getStringXML(chart_node, true) + "\n");
                        }
                        this.move(chart_node, move_node);
                    }
                }
                if ((merged_node = this.merge(chart_node, pending_node)) != null) {
                    at_least_one_merge = true;
                    this.moved_node = null;
                    int position = this.xutils.getWordsNumber(merged_node);
                    if (this.tracing) {
                        System.out.println("MERGE SUCCESSFUL! (inserted at chart #" + position + ")\n" + this.xutils.getStringXML(merged_node, true) + "\n-----\n");
                    }
                    this.chart[position].add(merged_node.cloneNode(true));
                    ma_buffer.add(this.moved_node);
                    this.ma_buffers[position].add(ma_buffer);
                    continue;
                }
                if (!this.tracing) continue;
                System.out.println("MERGE failed!");
            }
        }
        if (!at_least_one_merge) {
            this.merge_last_resource();
        }
    }

    private void close() {
        if (this.tracing) {
            System.out.println("CLOSING open phases...");
        }
        for (int i = 0; i < this.chart[this.chart.length - 1].size(); ++i) {
            Element node = (Element)this.chart[this.chart.length - 1].get(i);
            List ma_buffer = (List)this.ma_buffers[this.chart.length - 1].get(i);
            int size_buffer = ma_buffer.size();
            if (this.tracing) {
                System.out.println("Attempt to close: " + this.xutils.getStringXML(node, true) + " buffer size: " + size_buffer);
            }
            this.setComplete(node);
            if (this.complete) {
                if (this.tracing) {
                    System.out.println("This node is COMPLETE!");
                }
                if (size_buffer == 0 || !this.tracing) continue;
                System.out.println("... but A-buffer is not empty: " + this.xutils.getStringXML((Node)ma_buffer.get(0), true));
                continue;
            }
            if (size_buffer == 0) {
                this.chart[this.chart.length - 1].remove(i);
                --i;
                if (!this.tracing) continue;
                System.out.println("This node is NOT 0COMPLETE! Missing argument at: " + this.xutils.getStringXML(node, true));
                continue;
            }
            for (int j = 0; j < size_buffer; ++j) {
                Element moved = (Element)ma_buffer.get(j);
                if (moved == null) continue;
                if (this.tracing) {
                    System.out.println("Moved element: " + this.xutils.getStringXML(moved, true));
                }
                this.move(node, moved);
            }
        }
    }

    private Node getFirstNode(Node nedge) {
        Node n = nedge;
        if (nedge.hasChildNodes()) {
            for (Node kid = nedge.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 1) continue;
                n = kid;
            }
        }
        return n;
    }

    private List getParentPhases(Element n) {
        ArrayList<Element> parent_phases = new ArrayList<Element>();
        ArrayList<String> parent_phases_st = new ArrayList<String>();
        String cat = n.getAttribute("cat");
        if (cat.contains("+")) {
            String[] cat_split = cat.split("\\+");
            cat = cat_split[0];
        }
        for (int i = 0; i < this.size_ps_found; ++i) {
            String[] selected_ps = (String[])this.ps_found.get(i);
            if (cat.length() <= 0 || !cat.equals(selected_ps[0])) continue;
            Element n_cloned = (Element)n.cloneNode(true);
            Element parent = this.parse.createElement("node");
            parent.setAttribute("cat", selected_ps[1]);
            if (cat.contains("P.")) {
                parent.setAttribute("role", "adj." + cat.substring(2, cat.length()));
            } else if (cat.contains("C.rel")) {
                parent.setAttribute("role", "adj.rel.restr");
            } else if (cat.contains("C.subord.")) {
                parent.setAttribute("role", "adj." + cat.substring(9, cat.length()));
            } else if (cat.contains("C.coord")) {
                parent.setAttribute("role", "adj.coord");
            }
            if (this.isHead(n)) {
                parent.setAttribute("role", "head");
            }
            if (n_cloned.hasAttribute("agree")) {
                parent.setAttribute("agree", n_cloned.getAttribute("agree"));
            }
            parent.appendChild(n_cloned);
            String parent_st = this.xutils.getStringXML(parent, false);
            if (parent_phases_st.contains(parent_st)) continue;
            if (this.tracing) {
                System.out.println("- parent phase: " + this.xutils.getStringXML(parent, true));
            }
            parent_phases_st.add(parent_st);
            parent_phases.add(parent);
        }
        return parent_phases;
    }

    private boolean isFinite(String cat_n) {
        boolean finite = true;
        if (cat_n.contains("inf") || cat_n.contains("part") || cat_n.contains("V.imp")) {
            finite = false;
        }
        return finite;
    }

    private Node merge(Element chart_el, Element pending_el) {
        ++this.counter;
        Node node_merged = null;
        this.active_node = null;
        this.setActiveNode(chart_el);
        if (this.tracing) {
            System.out.println("Active node: " + this.xutils.getStringXML(this.active_node, true));
        }
        String chart_active_cat = this.active_node.getAttribute("cat");
        String penging_cat = pending_el.getAttribute("cat");
        String penging_child_cat = ((Element)pending_el.getFirstChild()).getAttribute("cat");
        boolean pending_edge = this.isPhaseEdge(pending_el);
        boolean chart_ishead = this.hasChildRole(this.active_node, "head");
        boolean chart_isheaded = this.hasChildRole(this.active_node, "head");
        boolean pending_ishead = this.hasChildRole(pending_el, "head");
        boolean special = false;
        if ((penging_cat.equals("INT") || penging_cat.contains("NE")) && chart_active_cat.equals("NP")) {
            chart_active_cat = "INT";
            special = true;
        }
        if (chart_active_cat.equals(penging_cat)) {
            if (chart_ishead && !pending_ishead) {
                Node cloned_node = chart_el.cloneNode(true);
                this.active_node = null;
                this.setActiveNode((Element)cloned_node);
                if (pending_edge) {
                    if (this.tracing) {
                        System.out.println("1. [XP X [XP F]]");
                    }
                    this.active_node.appendChild(pending_el);
                } else if (this.parametricConstraint(penging_child_cat, chart_ishead)) {
                    if (this.tracing) {
                        System.out.println("2. [XP X F]");
                    }
                    Node cloned_pending = pending_el.cloneNode(true);
                    this.active_node.appendChild(this.getFirstNode(cloned_pending));
                }
                this.setRole(this.active_node);
                if (special) {
                    ((Element)cloned_node).setAttribute("cat", penging_cat);
                }
                node_merged = cloned_node;
            } else if (chart_ishead && pending_ishead) {
                if (this.tracing) {
                    System.out.println("*[XP X X]");
                }
            } else {
                if (this.tracing) {
                    System.out.println("3. [XP (F) F]");
                }
                Node cloned_pending_el = pending_el.cloneNode(true);
                NodeList cloned_pending_children = cloned_pending_el.getChildNodes();
                Node cloned_node = chart_el.cloneNode(true);
                this.active_node = null;
                this.setActiveNode((Element)cloned_node);
                for (int i = 0; i < cloned_pending_children.getLength(); ++i) {
                    Element cloned_pending_child = (Element)cloned_pending_children.item(0);
                    if (this.agree(this.active_node, cloned_pending_child)) {
                        this.active_node.appendChild(cloned_pending_child);
                        this.active_node.setAttribute("agree", cloned_pending_child.getAttribute("agree"));
                        --i;
                        continue;
                    }
                    if (!this.tracing) continue;
                    System.out.println("4. [FAILED agree]");
                }
                this.setRole(this.active_node);
                if (special) {
                    ((Element)cloned_node).setAttribute("cat", penging_cat);
                }
                node_merged = cloned_node;
            }
        } else {
            this.setComplete(chart_el);
            if (this.complete && penging_cat.equals("VP")) {
                if (this.tracing) {
                    System.out.println("5. [[XP] YP]");
                }
                Node cloned_node = pending_el.cloneNode(true);
                Element cloned_node_chart = (Element)chart_el.cloneNode(true);
                cloned_node.insertBefore(cloned_node_chart, this.getFirstNode(cloned_node));
                if (this.agree(this.getFirstNode(cloned_node), cloned_node_chart)) {
                    cloned_node_chart.setAttribute("role", "arg.subj");
                }
                this.moved_node = cloned_node_chart;
                node_merged = cloned_node;
            } else {
                if (this.tracing) {
                    System.out.println("FAILED: (ex 6. [XP [YP]]) ... but maybe because of a missing subcat feature... trying recovery:");
                }
                this.setComplete(this.active_node);
                if (this.complete && penging_cat.equals("NP") && pending_edge) {
                    Element cloned_node_chart = (Element)chart_el.cloneNode(true);
                    this.active_node = null;
                    this.setActiveNode(cloned_node_chart);
                    Element cloned_node_pending = (Element)pending_el.cloneNode(true);
                    cloned_node_pending.setAttribute("role", "arg.obj");
                    this.active_node.appendChild(cloned_node_pending);
                    this.setRole(this.active_node);
                    node_merged = cloned_node_chart;
                    if (this.tracing) {
                        System.out.println("6. [XP [YP]]) (recovered)");
                    }
                }
            }
        }
        return node_merged;
    }

    public void merge_last_resource() {
        if (this.tracing) {
            System.out.println("\n\n\n=== attempt to buiild something with === \nPending:" + this.xutils.getStringXML(this.last_resource_pending, true) + "\n First_chart" + this.xutils.getStringXML(this.first_chart_node, true));
        }
        if (this.last_resource_pending != null) {
            Element cloned_node_chart = (Element)this.first_chart_node.cloneNode(true);
            this.active_node = null;
            this.setActiveNode(cloned_node_chart);
            Element cloned_node_pending = (Element)this.last_resource_pending.cloneNode(true);
            this.active_node.appendChild(cloned_node_pending);
            this.setRole(this.active_node);
            int position = this.xutils.getWordsNumber(cloned_node_chart);
            if (this.tracing) {
                System.out.println("MERGE SUCCESSFUL! (inserted at chart #" + position + ")\n" + this.xutils.getStringXML(cloned_node_chart, true) + "\n-----\n");
            }
            this.chart[position].add(cloned_node_chart);
            ArrayList<Object> ma_buffer = new ArrayList<Object>();
            ma_buffer.add(null);
            this.ma_buffers[position].add(ma_buffer);
        }
    }

    public boolean parametricConstraint(String cat_second, boolean first_isheaded) {
        boolean ok = true;
        if (first_isheaded && (cat_second.contains("aux") || cat_second.contains("asp") || cat_second.contains("mod"))) {
            ok = false;
        }
        if (this.tracing) {
            System.out.println("parametric check: cat_second=" + cat_second + "first_ishead=" + first_isheaded);
        }
        return ok;
    }

    private List getTTrees(String[] string, int i) {
        int size_tt = this.tt_found.size();
        Object ef = null;
        ArrayList<Node> tt_list = new ArrayList<Node>();
        for (int n = 0; n < size_tt; ++n) {
            Boolean found = true;
            String[] tt_selected = (String[])this.tt_found.get(n);
            String[] tt_found_split = tt_selected[0].split(" ");
            this.size_tt_sel = tt_found_split.length;
            for (int m = 0; m < this.size_tt_sel; ++m) {
                if (this.tracing) {
                    System.out.println(tt_found_split[m] + "=" + string[m + i]);
                }
                if (tt_found_split[m].equalsIgnoreCase(string[m + i])) continue;
                found = false;
                break;
            }
            if (!found.booleanValue()) continue;
            if (this.tracing) {
                System.out.println("+ TT: " + tt_selected[0]);
            }
            Node nt = this.parse.importNode(this.parseXML(tt_selected[1]), true);
            tt_list.add(nt);
        }
        return tt_list;
    }

    private Node createPoSNode(String token, String lemma, String cat, String subcat, String role, String agree, int position) {
        if (!agree.equals("")) {
            agree = " agree=\"" + agree + "\"";
        }
        if (!role.equals("")) {
            role = " role=\"" + role + "\"";
        }
        if (!subcat.equals("")) {
            subcat = " subcat=\"" + subcat + "\"";
        }
        String pos = "<word cat=\"" + cat + "\"" + subcat + agree + role + " lemma=\"" + lemma + "\" entity=\"" + Integer.toString(position) + "\">" + token + "</word>";
        Node node = this.parse.importNode(this.parseXML(pos), true);
        return node;
    }

    private List getPoS(String word, int position) {
        ArrayList n_pos = new ArrayList();
        int size = this.pos_found.size();
        for (int i = 0; i < size; ++i) {
            String[] pos_sel = (String[])this.pos_found.get(i);
            if (!word.equalsIgnoreCase(pos_sel[0])) continue;
            Node pos = this.createPoSNode(pos_sel[0], pos_sel[1], pos_sel[2], pos_sel[3], pos_sel[4], pos_sel[5], position);
            if (this.tracing) {
                System.out.println("+ POS: [" + pos_sel[0] + "-" + pos_sel[1] + "-" + pos_sel[2] + "-" + pos_sel[3] + "-" + pos_sel[4] + "-" + pos_sel[5] + "]");
            }
            List phase_nodes = this.getParentPhases((Element)pos);
            n_pos.addAll(phase_nodes);
        }
        if (n_pos.size() == 0) {
            String[] guessedPoS = this.guessPoS(word);
            n_pos.addAll(this.getParentPhases((Element)this.createPoSNode(word, word, guessedPoS[0], "", "", guessedPoS[1], position)));
            if (this.tracing) {
                System.out.println("+ POS: [" + word + "-" + word + "-" + guessedPoS[0] + "-  -  -" + guessedPoS[1] + "]");
            }
        }
        return n_pos;
    }

    private void getPotentialPhaseships() throws IOException {
        String ps = this.grammar.phaseships.readLine();
        while (ps != null) {
            String[] selected_ps = ps.split("\t");
            this.ps_found.add(selected_ps);
            ps = this.grammar.phaseships.readLine();
        }
    }

    private void getPhases() throws IOException {
        String ps = this.grammar.phases.readLine();
        while (ps != null) {
            ps = this.grammar.phases.readLine();
        }
    }

    private void getPotentialLeftEdges() throws IOException {
        String lp = this.grammar.phaseedges.readLine();
        while (lp != null) {
            String[] selected_ps = lp.split("\t");
            this.lp_found.add(selected_ps);
            lp = this.grammar.phaseedges.readLine();
        }
    }

    private void getPotentialCorpusTTrees(String sentence) throws IOException {
        String clean_sentence = XmlUtils.removeMarks(sentence);
        String tt = this.grammar.ttrees.readLine();
        while (tt != null) {
            String[] selected_tt = tt.split("\t");
            if (!selected_tt[0].toLowerCase().equals("") && (clean_sentence.toLowerCase() + " ").contains(selected_tt[0].toLowerCase())) {
                this.tt_found.add(selected_tt);
                if (this.tracing) {
                    System.out.println("FOUND TTs: " + selected_tt[0] + " " + selected_tt[1]);
                }
            }
            tt = this.grammar.ttrees.readLine();
        }
    }

    private void getPotentialCorpusPoS(String sentence) throws IOException {
        String pos = this.grammar.corpus_lexicon.readLine();
        while (pos != null) {
            String[] selected_pos = pos.split("\t");
            if ((" " + sentence.toLowerCase() + " ").contains(" " + selected_pos[0].toLowerCase() + " ")) {
                this.pos_found.add(selected_pos);
            }
            pos = this.grammar.corpus_lexicon.readLine();
        }
    }

    private void getPotentialPoS(String sentence) throws IOException {
        String pos = this.grammar.lexicon.readLine();
        while (pos != null) {
            String[] selected_pos = pos.split("\t");
            if ((" " + sentence + " ").contains(" " + selected_pos[0] + " ")) {
                String lemma = selected_pos[1];
                String agree = "";
                String role = "";
                String cat = "";
                String[] cat_array = selected_pos[2].split(":");
                if (cat_array.length > 1) {
                    agree = cat_array[1];
                    cat = cat_array[0];
                } else {
                    cat = selected_pos[2];
                }
                if (cat.substring(0, 1).equalsIgnoreCase("V") && !cat.toLowerCase().contains("aux") && !cat.toLowerCase().contains("asp") && !cat.toLowerCase().contains("mod") || cat.substring(0, 1).equalsIgnoreCase("N") || cat.contains("N.pro")) {
                    role = "head";
                }
                String[] final_pos = new String[]{selected_pos[0], lemma, cat, "", role, agree, ""};
                this.pos_found.add(final_pos);
            }
            pos = this.grammar.lexicon.readLine();
        }
    }

    public static String[] getTokens(String l) {
        return l.split("\\s");
    }

    public Element parseXML(String in) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(PMG_Parser.class.getName()).log(Level.SEVERE, null, ex);
        }
        CharArrayReader reader = new CharArrayReader(in.toCharArray());
        Document doc = null;
        try {
            doc = builder.parse(new InputSource(reader));
        }
        catch (SAXException ex) {
            Logger.getLogger(PMG_Parser.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(PMG_Parser.class.getName()).log(Level.SEVERE, null, ex);
        }
        return doc.getDocumentElement();
    }

    public String getParseXML(Document d) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "3");
        DOMSource source = new DOMSource(d);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
    }

    private boolean hasFeature(Node n, String feature, String value) {
        boolean result = false;
        if (((Element)n).hasAttribute(feature) && ((Element)n).getAttribute(feature).equals(value)) {
            result = true;
        }
        return result;
    }

    private boolean isHead(Node n) {
        return this.hasFeature(n, "role", "head");
    }

    private boolean hasChildRole(Element node, String role) {
        boolean hasrole = false;
        if (node.hasChildNodes()) {
            for (Node kid = node.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 1 || !this.hasFeature(kid, "role", role)) continue;
                hasrole = true;
                break;
            }
        }
        return hasrole;
    }

    private Node getHead(Node node) {
        Node head = null;
        if (node != null && node.hasChildNodes()) {
            for (Node kid = node.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
                if (kid.getNodeType() != 1 || !this.hasFeature(kid, "role", "head")) continue;
                head = kid;
            }
        }
        return head;
    }

    private boolean isPhaseEdge(Node nedge) {
        boolean edge = false;
        String cat = "";
        Node node_nedge = this.getFirstNode(nedge);
        if (((Element)node_nedge).hasAttribute("cat")) {
            String c = ((Element)node_nedge).getAttribute("cat");
            cat = c.length() > 1 ? ((Element)node_nedge).getAttribute("cat").substring(0, 2) : ((Element)node_nedge).getAttribute("cat");
        }
        for (int i = 0; i < this.size_lp_found; ++i) {
            String[] selected_lp = (String[])this.lp_found.get(i);
            if (!cat.equals(selected_lp[0])) continue;
            if (this.tracing) {
                System.out.println(selected_lp[0] + " id an edge!");
            }
            edge = true;
            break;
        }
        return edge;
    }

    private void setComplete(Node node) {
        this.complete = false;
        Node head = this.getHead(node);
        if (head != null) {
            if (!((Element)head).hasAttribute("subcat")) {
                this.complete = true;
            } else if (this.checkThematicSelection(node, ((Element)head).getAttribute("subcat"))) {
                this.complete = true;
            }
        }
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            if (!children.item(i).getNodeName().equals("node")) continue;
            this.setComplete(children.item(i));
        }
    }

    private boolean checkThematicSelection(Node node, String subcat) {
        boolean theta_complete = false;
        boolean subj = false;
        boolean obj = false;
        boolean indobj = false;
        boolean predobj = false;
        if (subcat.equals("intransitive")) {
            while (node != null) {
                if (!subj && this.hasChildRole((Element)node, "arg.subj")) {
                    subj = true;
                }
                if (this.hasFeature(node, "role", "head")) {
                    node = node.getParentNode();
                    continue;
                }
                node = null;
            }
            if (subj) {
                theta_complete = true;
            }
        } else if (subcat.equals("transitive")) {
            while (node != null) {
                if (!subj && this.hasChildRole((Element)node, "arg.subj")) {
                    subj = true;
                }
                if (!obj && this.hasChildRole((Element)node, "arg.obj")) {
                    obj = true;
                }
                if (this.hasFeature(node, "role", "head")) {
                    node = node.getParentNode();
                    continue;
                }
                node = null;
            }
            if (subj && obj) {
                theta_complete = true;
            }
        } else if (subcat.equals("ditransitive")) {
            while (node != null) {
                if (!subj && this.hasChildRole((Element)node, "arg.subj")) {
                    subj = true;
                }
                if (!obj && this.hasChildRole((Element)node, "arg.obj")) {
                    obj = true;
                }
                if (!indobj && this.hasChildRole((Element)node, "arg.indobj")) {
                    indobj = true;
                }
                if (this.hasFeature(node, "role", "head")) {
                    node = node.getParentNode();
                    continue;
                }
                node = null;
            }
            if (subj && obj && indobj) {
                theta_complete = true;
            }
        } else if (subcat.equals("copula")) {
            while (node != null) {
                if (!subj && this.hasChildRole((Element)node, "arg.subj")) {
                    subj = true;
                }
                if (!obj && this.hasChildRole((Element)node, "arg.predobj")) {
                    predobj = true;
                }
                if (this.hasFeature(node, "role", "head")) {
                    node = node.getParentNode();
                    continue;
                }
                node = null;
            }
            if (subj && predobj) {
                theta_complete = true;
            }
        }
        if (this.tracing) {
            System.out.println("Thematic completion is set to: " + theta_complete);
        }
        return theta_complete;
    }

    private boolean agree(Node n, Node m) {
        if (this.tracing) {
            System.out.println("CHECK AGREE between: " + this.xutils.getStringXML(n, true) + "\n" + this.xutils.getStringXML(m, true));
        }
        boolean agr = true;
        if (((Element)n).hasAttribute("agree") && ((Element)m).hasAttribute("agree")) {
            Node head_n = this.getHead(n);
            if (head_n == null) {
                head_n = n;
            }
            String agr_n = ((Element)head_n).getAttribute("agree");
            String cat_n = ((Element)head_n).getAttribute("cat");
            String role_n = ((Element)head_n).getAttribute("role");
            String agr_m = ((Element)m).getAttribute("agree");
            String cat_m = ((Element)n).getAttribute("cat");
            if (role_n.equals("head") && this.isFinite(cat_n) && cat_m.equals("NP")) {
                if (this.tracing) {
                    System.out.println("AGREE V-S: " + agr_n + " - " + agr_m);
                }
                if (agr_n.contains("p") && agr_m.contains("s") || agr_n.contains("s") && agr_m.contains("p")) {
                    agr = false;
                } else if (agr_m.contains("2") && !agr_n.contains("2") || agr_m.contains("1") && !agr_n.contains("1")) {
                    agr = false;
                }
            } else if (role_n.equals("head") && cat_n.equals("V.part.past") && cat_m.equals("NP")) {
                if (this.tracing) {
                    System.out.println("AGREE O-V.p.past: " + agr_n + " - " + agr_m);
                }
                if (agr_n.contains("p") && agr_m.contains("s") || agr_n.contains("s") && agr_m.contains("p")) {
                    agr = false;
                } else if (agr_n.contains("m") && agr_m.contains("f") || agr_n.contains("f") && agr_m.contains("m")) {
                    agr = false;
                }
            } else if (!(agr_n.equals("") || agr_m.equals("") || agr_n.equals("n") || agr_m.equals("n") || agr_n.equals(agr_m))) {
                agr = false;
                if (agr_n.contains("m") && agr_m.contains("m") || agr_n.contains("f") && agr_m.contains("f")) {
                    agr = true;
                }
                if (agr_n.contains("s") && agr_m.contains("s") || agr_n.contains("p") && agr_m.contains("p")) {
                    agr = true;
                }
                if (this.tracing) {
                    System.out.println("AGREE NP, aux/mod/asp-V: " + agr_n + " - " + agr_m);
                }
            } else if (this.tracing) {
                System.out.println("AGREE DEFAULT: " + agr_n + " - " + agr_m);
            }
        } else if (this.tracing) {
            System.out.println("NO AGREEMENT CONSTRAINTS!");
        }
        return agr;
    }

    private void setActiveNode(Element n) {
        if (n.hasChildNodes()) {
            for (Node kid = n.getLastChild(); kid != null; kid = kid.getPreviousSibling()) {
                if (kid.getNodeName().equals("word")) {
                    if (this.isHead((Element)kid)) {
                        if (this.active_node == null) {
                            this.right_most_head = (Element)kid;
                            this.active_node = n;
                        }
                        break;
                    }
                    if (this.active_node != null) continue;
                    this.active_node = n;
                    continue;
                }
                if (!kid.getNodeName().equals("node")) continue;
                if (this.hasChildRole((Element)kid, "head")) {
                    if (this.active_node != null) continue;
                    this.active_node = (Element)kid;
                    this.setActiveNode((Element)kid);
                    break;
                }
                this.active_node = (Element)kid;
                this.setActiveNode((Element)kid);
            }
        } else {
            this.active_node = n;
        }
    }

    private void removePoSDuplicated() {
        if (this.tracing) {
            System.out.println("pos size before: " + this.pos_found.size());
        }
        for (int i = 0; i < this.pos_found.size(); ++i) {
            String[] pos_sel = (String[])this.pos_found.get(i);
            String s = pos_sel[0] + pos_sel[1] + pos_sel[2] + pos_sel[3] + pos_sel[4] + pos_sel[5];
            for (int j = i + 1; j < this.pos_found.size(); ++j) {
                pos_sel = (String[])this.pos_found.get(j);
                String s_bis = pos_sel[0] + pos_sel[1] + pos_sel[2] + pos_sel[3] + pos_sel[4] + pos_sel[5];
                if (!s.equalsIgnoreCase(s_bis)) continue;
                this.pos_found.remove(j);
                --j;
                --i;
            }
        }
        if (this.tracing) {
            System.out.println("pos size after: " + this.pos_found.size());
        }
    }

    private void move(Node node, Node moved) {
        this.setWaitingNode(node);
        this.predicted_node.getParentNode().removeChild(this.predicted_node);
        ((Element)moved).setAttribute("role", this.predicted_node.getAttribute("role"));
    }

    private void setRole(Element node) {
        if (this.tracing) {
            System.out.println("##### attempt to set a role for node: " + this.xutils.getStringXML(node, true));
        }
        boolean genitive = false;
        if (!node.hasAttribute("role") || node.getAttribute("role").contains("adj")) {
            NodeList nl = node.getChildNodes();
            int size = nl.getLength();
            for (int i = 0; i < size; ++i) {
                Element n = (Element)nl.item(i);
                String cat = n.getAttribute("cat");
                String lemma = "";
                if (n.hasAttribute("lemma")) {
                    lemma = n.getAttribute("lemma");
                }
                if (lemma != null && lemma.contains("di")) {
                    genitive = true;
                }
                if (!genitive || !cat.contains("pers")) continue;
                node.setAttribute("role", "adj.subj");
                ((Element)node.getFirstChild()).setAttribute("cat", "P.genitive");
            }
        }
        if (this.tracing) {
            System.out.println("##### gen: " + genitive);
            System.out.println("##### role for node: " + this.xutils.getStringXML(node, true));
        }
    }

    private void setWaitingNode(Node node) {
        NodeList nl = node.getChildNodes();
        int size = nl.getLength();
        for (int i = 0; i < size; ++i) {
            Element kid = (Element)nl.item(i);
            if (!kid.getNodeName().equals("node")) continue;
            if (kid.getNodeValue() == null) {
                this.predicted_node = kid;
                break;
            }
            this.setWaitingNode(kid);
        }
    }
}

