/*
 * Decompiled with CFR 0.152.
 */
package pmg_tools;

import java.io.File;
import java.io.FilenameFilter;
import pmg_tools.PMG_Grammar;
import pmg_tools.XMLReader;
import pmg_tools.XmlUtils;

public class PMG_GrammarExtractor {
    static XmlUtils xutils = new XmlUtils();
    static String lexicon = "src/pmg_tools/resources/corpus-lex.txt";
    static String phases = "src/pmg_tools/resources/corpus-phases.txt";
    static String phases_freq = "src/pmg_tools/resources/corpus-phases-freq.txt";
    static String phases_ships = "src/pmg_tools/resources/corpus-phase_ships.txt";
    static String phases_left_corners = "src/pmg_tools/resources/corpus-left_corners.txt";
    static String terminal_trees = "src/pmg_tools/resources/corpus-t_trees.txt";
    static String rooted_trees = "src/pmg_tools/resources/corpus-r_trees.txt";
    static String node_cats = "src/pmg_tools/resources/corpus-node_cats.txt";
    static String word_cats = "src/pmg_tools/resources/corpus-word_cats.txt";
    static String dir = "C:\\Users\\cri\\Documents\\works\\corpora\\TG\\corpus tagged\\corpus-ITA-LIS-v1.1\\ita\\";
    static int nwords = 0;
    static int nsentences = 0;
    static int files = 0;

    public static void main(String[] args) {
        if (args.length == 1) {
            dir = args[0];
        }
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xml");
            }
        };
        File dir_ita = new File(dir);
        String[] files_ita = dir_ita.list(filter);
        PMG_Grammar mg = new PMG_Grammar();
        if (files_ita != null) {
            for (int i = 0; i < files_ita.length; ++i) {
                XMLReader reader_liv = new XMLReader(dir + files_ita[i]);
                mg.setGrammar(reader_liv.getRoot());
                nsentences += mg.nsentences;
                nwords += mg.ntotwords;
                ++files;
            }
        }
        String lex = mg.getLex();
        String pha = mg.getPhases();
        mg.reorder(mg.terminal_trees);
        String ttrees = mg.getTTrees();
        System.out.println("Number of files processed: " + files);
        System.out.println("Number of sentences processed: " + nsentences);
        System.out.println("Number of tokens processed: " + nwords);
        System.out.println("Number of lexical items: " + mg.lex.size());
        XmlUtils.writeFile(lexicon, lex);
        System.out.println("Number of complex phases: " + mg.phases.size());
        XmlUtils.writeFile(phases, pha);
        System.out.println("Number of phaseships: " + mg.phase_ships.size());
        XmlUtils.writeFile(phases_ships, mg.getPhase_ships());
        System.out.println("Number of phase left edges: " + mg.phase_left_corners.size());
        XmlUtils.writeFile(phases_left_corners, mg.getPhase_left_corners());
        System.out.println("Number of Node Categories: " + mg.node_cats.size());
        XmlUtils.writeFile(node_cats, mg.getNode_cats());
        System.out.println("Number of Word Categories: " + mg.word_cats.size());
        XmlUtils.writeFile(word_cats, mg.getWord_cats());
        System.out.println("Number of terminal trees: " + mg.terminal_trees.size());
        XmlUtils.writeFile(terminal_trees, ttrees);
    }
}

