/*
 * Decompiled with CFR 0.152.
 */
package pmg_tools;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pmg_tools.Compare;
import pmg_tools.XmlUtils;

public class PMG_Grammar {
    Hashtable<String, Integer> lex = new Hashtable();
    Hashtable<String, Integer> phases = new Hashtable();
    Hashtable<String, Integer> phase_ships = new Hashtable();
    Hashtable<String, Integer> phase_left_corners = new Hashtable();
    Hashtable<String, String> terminal_trees = new Hashtable();
    Hashtable<String, String> rooted_trees = new Hashtable();
    Hashtable<String, Integer> node_cats = new Hashtable();
    Hashtable<String, Integer> word_cats = new Hashtable();
    Hashtable<String, List> phase_types = new Hashtable();
    Hashtable<String, Integer> phases_simple = new Hashtable();
    Compare cp = new Compare();
    String string_terminal_trees = "";
    int subcat = 2;
    int nsentences = 0;
    int ntotwords = 0;
    int newwords = 0;
    int newphases = 0;
    int nswords = 0;
    int nsphases = 0;
    int nttress = 0;
    int newttress = 0;
    Object[] lexArray;
    Object[] phasesArray;
    XmlUtils xutils = new XmlUtils();
    boolean ttress_extraction_completed = false;

    public PMG_Grammar() {
    }

    public PMG_Grammar(Node node) {
        this.setWords(node);
        this.setPhases(node);
        this.getPhaseSimple(node, this.subcat);
    }

    public void setGrammar(Node node) {
        int size;
        NodeList expressions = ((Element)node).getElementsByTagName("expression");
        this.nsentences = size = expressions.getLength();
        this.ntotwords = 0;
        for (int i = 0; i < size; ++i) {
            this.newwords = 0;
            this.newphases = 0;
            this.newttress = 0;
            this.nswords = 0;
            this.nsphases = 0;
            this.nttress = 0;
            Node sentence = XmlUtils.findNextNode(expressions.item(i), "node");
            this.setWords(sentence);
            this.setPhases(sentence);
            this.setCats(sentence);
            this.setPhase_ships(sentence);
            this.setPhase_left_corners(sentence);
            this.xutils.removeMarks((Element)sentence);
            this.setFirstTree(sentence);
            this.setTTrees(sentence);
            this.ntotwords += this.nswords;
            System.out.println("Sentence " + (i + 1) + " (" + this.nswords + " words, " + this.nsphases + " phases) contributed with " + this.newwords + " new words and with " + this.newphases + " new phases:" + "\nlexical contribution = " + 100 * this.newwords / this.nswords + "%; grammar contribution = " + 100 * this.newphases / this.nsphases + "%.\n");
        }
    }

    public void setFirstTree(Node node) {
        String sttree = this.xutils.getStringXML(node, false);
        this.xutils.clearText();
        this.xutils.setText((Element)node);
        String sttree_words = this.xutils.text;
        ++this.nttress;
        if (!this.terminal_trees.containsKey(sttree_words)) {
            this.terminal_trees.put(sttree_words, sttree);
            ++this.newttress;
        }
    }

    public void setTTrees(Node node) {
        Node first_word = this.xutils.findNode(node, "word");
        if (first_word != null && !this.xutils.isLastLeaf(first_word)) {
            Node ttree = first_word.getParentNode();
            String sttree = this.xutils.getStringXML(ttree, false);
            this.xutils.clearText();
            this.xutils.setText((Element)ttree);
            String sttree_words = this.xutils.text;
            ++this.nttress;
            if (!this.terminal_trees.containsKey(sttree_words)) {
                this.terminal_trees.put(sttree_words, sttree);
                ++this.newttress;
            }
            if (this.xutils.isRecursive(ttree)) {
                Node cloned_ttree = ttree.cloneNode(true);
                Node non_recursive_ttree = this.xutils.removeNonTerminals(cloned_ttree);
                this.setTTrees(non_recursive_ttree);
            }
            this.xutils.removeTerminals(first_word);
            this.setTTrees(node);
        }
    }

    private void setCats(Node node) {
        String cat = ((Element)node).getAttribute("cat");
        String nodename = node.getNodeName();
        if (nodename.equals("node")) {
            if (this.node_cats.containsKey(cat)) {
                this.node_cats.put(cat, this.node_cats.get(cat) + 1);
            } else {
                this.node_cats.put(cat, 1);
            }
        } else if (nodename.equals("word")) {
            if (this.word_cats.containsKey(cat)) {
                this.word_cats.put(cat, this.word_cats.get(cat) + 1);
            } else {
                this.word_cats.put(cat, 1);
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            this.setCats(children.item(i));
        }
    }

    private void setPhase_left_corners(Node node) {
        String father = ((Element)node).getAttribute("cat");
        if (node.hasChildNodes()) {
            Node left_edge = node.getFirstChild();
            String s = "";
            if (left_edge.getNodeName().equals("word")) {
                s = ((Element)left_edge).getAttribute("cat");
                if (this.phase_left_corners.containsKey(s + "\t" + father)) {
                    this.phase_left_corners.put(s + "\t" + father, this.phase_left_corners.get(s + "\t" + father) + 1);
                } else {
                    this.phase_left_corners.put(s + "\t" + father, 1);
                }
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            this.setPhase_left_corners(children.item(i));
        }
    }

    private void setPhase_ships(Node node) {
        String father = ((Element)node).getAttribute("cat");
        String role = "";
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            String s = "";
            if (children.item(i).getNodeType() == 3) continue;
            s = ((Element)children.item(i)).getAttribute("cat");
            if (((Element)children.item(i)).hasAttribute("role")) {
                role = ((Element)children.item(i)).getAttribute("role");
            }
            if (this.phase_ships.containsKey(s + "\t" + father + "\t" + role)) {
                this.phase_ships.put(s + "\t" + father + "\t" + role, this.phase_ships.get(s + "\t" + father + "\t" + role) + 1);
            } else {
                this.phase_ships.put(s + "\t" + father + "\t" + role, 1);
            }
            this.setPhase_ships(children.item(i));
        }
    }

    private void setWords(Node node) {
        if (node.getNodeName().equals("word")) {
            String s = this.getWordString(node);
            ++this.nswords;
            if (this.lex.containsKey(s)) {
                this.lex.put(s, this.lex.get(s) + 1);
            } else {
                this.lex.put(s, 1);
                ++this.newwords;
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            this.setWords(children.item(i));
        }
    }

    private void setPhases(Node node) {
        if (node.getNodeName().equals("node")) {
            String s = this.getPhaseString(node);
            ++this.nsphases;
            if (this.phases.containsKey(s)) {
                this.phases.put(s, this.phases.get(s) + 1);
            } else {
                this.phases.put(s, 1);
                ++this.newphases;
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            this.setPhases(children.item(i));
        }
    }

    private void getPhaseSimple(Node node, int n) {
        if (node.getNodeName().equals("node")) {
            String s = this.getPhaseSimpleString(node, n);
            if (this.phases_simple.containsKey(s)) {
                this.phases_simple.put(s, this.phases_simple.get(s) + 1);
            } else {
                this.phases_simple.put(s, 1);
            }
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            this.getPhaseSimple(children.item(i), n);
        }
    }

    public String getWordString(Node node) {
        String s = node.getTextContent().toLowerCase();
        s = ((Element)node).hasAttribute("lemma") ? s + "\t" + ((Element)node).getAttribute("lemma") : s + "\t";
        s = s + "\t" + ((Element)node).getAttribute("cat");
        s = ((Element)node).hasAttribute("subcat") ? s + "\t" + ((Element)node).getAttribute("subcat") : s + "\t";
        s = ((Element)node).hasAttribute("role") ? s + "\t" + ((Element)node).getAttribute("role") : s + "\t";
        s = ((Element)node).hasAttribute("agree") ? s + "\t" + ((Element)node).getAttribute("agree") : s + "\t";
        return s;
    }

    public String getPhaseString(Node node) {
        String s = ((Element)node).getAttribute("cat");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            s = s + "\t" + ((Element)children.item(i)).getAttribute("cat");
        }
        return s;
    }

    private String getPhaseSimpleString(Node node, int n) {
        String s = this.getSubCatDepth(((Element)node).getAttribute("cat"), n);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1 || this.getSubCatDepth(((Element)children.item(i)).getAttribute("cat"), 1).equals("END")) continue;
            s = s + "\t" + this.getSubCatDepth(((Element)children.item(i)).getAttribute("cat"), n);
            if (!((Element)children.item(i)).hasAttribute("role") || ((Element)children.item(i)).getAttribute("role").equals(" ") || ((Element)children.item(i)).getAttribute("role").equals("")) continue;
            s = s + ":" + ((Element)children.item(i)).getAttribute("role");
        }
        return s;
    }

    private String getSubCatDepth(String s, int n) {
        String sf = "";
        String[] sp = s.split("\\.");
        if (sp.length > n) {
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sf = sf + ".";
                }
                sf = sf + sp[i];
            }
        } else {
            sf = s;
        }
        return sf;
    }

    public String getLex() {
        return this.stringArray(this.lex);
    }

    public String getSimplePhases() {
        return this.stringArray(this.phases_simple);
    }

    public String getPhases() {
        return this.stringArrayOnlyKeys(this.phases);
    }

    public String getPhase_left_corners() {
        return this.stringArray(this.phase_left_corners);
    }

    public String getPhase_ships() {
        return this.stringArray(this.phase_ships);
    }

    public String getWord_cats() {
        return this.stringArray(this.word_cats);
    }

    public String getNode_cats() {
        return this.stringArray(this.node_cats);
    }

    public String getTTrees() {
        return this.string_terminal_trees;
    }

    public void reorder(Hashtable ht) {
        Hashtable<String, Integer> newht = new Hashtable<String, Integer>();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] count = key.split(" ");
            int size = count.length;
            if (size <= 1) continue;
            newht.put(key, size);
        }
        this.phasesArray = newht.entrySet().toArray();
        Arrays.sort(this.phasesArray, this.cp);
        for (int i = 0; i < this.phasesArray.length; ++i) {
            String key = (String)((Map.Entry)this.phasesArray[i]).getKey();
            String value = (String)ht.get(key);
            this.string_terminal_trees = this.string_terminal_trees + key + "\t" + value + "\n";
        }
        this.string_terminal_trees = this.string_terminal_trees.replaceAll("$\n", "");
    }

    public int count_tokens(String s) {
        String[] st = s.split("\t");
        String[] tokens = st[0].split(" ");
        return tokens.length;
    }

    public String stringArray(Hashtable ht) {
        String s_lex = "";
        this.phasesArray = ht.entrySet().toArray();
        Arrays.sort(this.phasesArray, this.cp);
        for (int i = 0; i < this.phasesArray.length; ++i) {
            s_lex = s_lex + ((Map.Entry)this.phasesArray[i]).getKey() + "\t(" + ((Map.Entry)this.phasesArray[i]).getValue() + ")\n";
        }
        return s_lex.replaceAll("$\n", "");
    }

    public String stringArrayOnlyKeys(Hashtable ht) {
        String s_lex = "";
        this.phasesArray = ht.entrySet().toArray();
        Arrays.sort(this.phasesArray, this.cp);
        for (int i = 0; i < this.phasesArray.length; ++i) {
            s_lex = s_lex + ((Map.Entry)this.phasesArray[i]).getKey() + "\n";
        }
        return s_lex.replaceAll("$\n", "");
    }

    public void orderArray(Object[] phasesArray) {
        Arrays.sort(phasesArray, this.cp);
    }

    public String stringArrayUnordered(Hashtable ht) {
        String s_lex = "";
        this.phasesArray = ht.entrySet().toArray();
        for (int i = 0; i < this.phasesArray.length; ++i) {
            s_lex = s_lex + ((Map.Entry)this.phasesArray[i]).getKey() + "\t" + ((Map.Entry)this.phasesArray[i]).getValue() + "\n";
        }
        return s_lex;
    }
}

