/*
 * Decompiled with CFR 0.152.
 */
package pmg_tools;

import java.io.BufferedReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import pmg_tools.PMG_GrammarLoader;
import pmg_tools.PMG_Parser;
import pmg_tools.XmlUtils;

public class Main {
    private static String sentence = "";
    private static String input = "";
    private static final String replace = "";
    private static final String removedchars = "[;:.',-?!\"aeiou\u00e8\u00e9\u00f2\u00e0\u00f9\u00ecx ]";
    private static boolean showXML = false;
    private static boolean tracing = false;
    private static XmlUtils xutils = new XmlUtils();
    private static String help = "Usage: \njava -jar liv2lis.jar [-p] \"italian sentence to be translated\"\njava -jar liv2lis.jar [-prof]\n\tit runs the corpus profiler (the corpus, both \"ITA\" and \"LIS\" directories, must be placed in the directory \"C:\\corpus\\\")\njava -jar liv2lis.jar [-penn]\n\t \"italian sentence to be translated\"it converts the XML output in the PENN format\n";

    public static void main(String[] args) throws IOException, CharConversionException, UnsupportedEncodingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        if (args.length == 0) {
            System.out.println("Inserisci la frase da analizzare:");
            input = br.readLine();
            showXML = true;
            Main.run();
        } else if (args.length == 1) {
            if (args[0].equals("-p")) {
                System.out.println("Inserisci la frase da analizzare:");
                input = br.readLine();
                showXML = true;
                tracing = false;
                Main.run();
            } else {
                input = args[0];
                Main.run();
            }
        } else if (args.length == 2) {
            if (args[0].equals("-p")) {
                input = args[1];
                showXML = true;
                tracing = false;
                Main.run();
            }
        } else {
            System.out.println(help);
        }
    }

    public static void run() {
        String line;
        sentence = line = input.trim();
        PMG_GrammarLoader grammar = null;
        try {
            grammar = new PMG_GrammarLoader("resources/phaseedges.txt", "resources/corpus-phase_ships.txt", "resources/corpus-phases.txt", "resources/corpus-lex.txt", "resources/lex_v05-utf8.txt", "resources/corpus-t_trees.txt");
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        PMG_Parser mp = new PMG_Parser(grammar, Main.clean_string(sentence), tracing);
        String s_parse = xutils.getParseXML(mp.parse);
        if (showXML) {
            System.out.println("***** PMG-Parser results (tracing ON: option '-p' specified)***** \n");
            System.out.println("Original sentence:\n" + sentence);
            System.out.println("Normalized sentence:\n" + Main.clean_string(sentence));
            System.out.println("Syntactic tree:\n" + s_parse);
        }
    }

    private static String clean_string(String s) {
        s = s.replace("e'", "\u00e8");
        s = s.replace("E'", "\u00e8");
        s = s.replace("a'", "\u00e0");
        s = s.replace("o'", "\u00f2");
        s = s.replace("i'", "\u00ec");
        s = s.replace("u'", "\u00f9");
        s = s.replace("\u0092", "'");
        s = s.replace("\u0093", "\"");
        s = s.replace("\u0094", "\"");
        s = s.replace("\u2019", "'");
        s = s.replace("\u201c", "\"");
        s = s.replace("\u201d", "\"");
        s = s.replaceAll("([LdtlCcnvs])'([AEIOUaeiou\u00e8])", "$1' $2");
        s = s.replaceAll("([\\[\\(\"])", "$1 ");
        s = s.replaceAll("([\\]\\)\"])", " $1");
        s = s.replaceAll("([%!?,\\-;:.])[^(0-9)(a-z)]", " $1 ");
        s = s.replaceAll("([%!?,\\-;:.])$", " $1");
        s = s.replaceAll(" [!?,\\-;:.]", replace);
        s = s.replaceAll(" l ", " l' ");
        s = s.replaceAll(" dell ", " dell' ");
        s = s.replaceAll(" dall ", " dall' ");
        s = s.replaceAll(" nell ", " nell' ");
        s = s.replaceAll("^l ", "l' ");
        s = s.replaceAll("^L ", "L' ");
        s = s.replaceAll("^C ", "C' ");
        s = s.replaceAll("^c ", "c' ");
        s = s.replaceAll(" c ", " c' ");
        s = s.replaceAll("^dell ", "dell' ");
        s = s.replaceAll("^Dell ", "Dell' ");
        s = s.replaceAll("^dall ", "dall' ");
        s = s.replaceAll("^Dall ", "Dall' ");
        s = s.replaceAll("^nell ", "nell' ");
        s = s.replaceAll("^Nell ", "Nell' ");
        s = s.replaceAll("^sull ", "sull' ");
        s = s.replaceAll("^Sull ", "Sull' ");
        s = s.replaceAll(" sull ", " sull' ");
        s = s.replaceAll("^ \"", "\"");
        s = s.replace(" p\u00f2", " po'");
        s = s.replace("   ", " ");
        s = s.replace("  ", " ");
        s = s.replaceAll("\n ", "\n");
        s = s.replaceAll(" \n", "\n");
        return s;
    }

    public static String skeletonKey(String l) {
        return l.replaceAll(removedchars, replace);
    }

    public static int getNWords(String l) {
        return l.trim().split("\\s").length;
    }
}

